/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.StringTag;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeTag
extends StringTag {
    private static final String defaultTimePattern;

    public TimeTag(Element auimlElement, Document hmcmlDocument, String resource, String[] resources) {
        super(auimlElement, hmcmlDocument, resource, resources);
    }

    void addSpinnerTag() {
        Element cell = this.findPosition();
        Element wTimeChooser = this.hmcmlDocument.createElementNS("wcl", "WTimeChooser");
        String pattern = defaultTimePattern;
        try {
            Locale locale = ClientUserContext.getUserContext().getLocale();
            DateFormat df = DateFormat.getTimeInstance(2, locale);
            if (df instanceof SimpleDateFormat) {
                pattern = ((SimpleDateFormat)df).toPattern();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        wTimeChooser.setAttribute("timeFormatPattern", pattern);
        wTimeChooser.setAttribute("isEnabled", this.enabled.equals("TRUE") ? "true" : "false");
        wTimeChooser.setAttribute("isReadOnly", this.readOnly.equals("TRUE") ? "true" : "false");
        wTimeChooser.setAttribute("isVisible", this.shown.equals("TRUE") ? "true" : "false");
        if (!this.tabOrder.equals("")) {
            wTimeChooser.setAttribute("tabIndex", this.tabOrder);
        }
        if (!this.optimumLength.equals("")) {
            wTimeChooser.setAttribute("size", this.optimumLength);
        } else {
            try {
                String size = this.getAttribute("SIZE");
                if (size != null && !size.startsWith("-1")) {
                    size = size.substring(0, size.indexOf(","));
                    int cvtSize = Integer.parseInt(size) / 11;
                    wTimeChooser.setAttribute("size", new Integer(cvtSize).toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        wTimeChooser.setAttributeNS("hmc", "property", this.getBindingProperty());
        this.addHmcId(wTimeChooser, this.name);
        cell.appendChild(wTimeChooser);
        this.setHmcmlElement(wTimeChooser);
        this.addHelpToHmcmlElement();
    }

    public void addValidator() {
        if (!this.type.equals("LABEL")) {
            String formatBinding;
            String mandatory;
            String latest;
            String earliest = this.getAttribute("EARLIEST");
            if (earliest == null) {
                earliest = "";
            }
            if ((latest = this.getAttribute("LATEST")) == null) {
                latest = "";
            }
            if ((mandatory = this.getAttribute("MANDATORY")) == null) {
                mandatory = "FALSE";
            }
            if ((formatBinding = this.getAttribute("FORMAT-BINDING")) == null) {
                formatBinding = "";
            }
            Element auimlFormatter = this.hmcmlDocument.createElementNS("hmc", "Format");
            auimlFormatter.setAttribute("class", "com.ibm.hwmca.fw.util.auimlcvt.auiml.formatters.AuimlDefaultFormatter");
            auimlFormatter.setAttribute("earliest", earliest);
            auimlFormatter.setAttribute("latest", latest);
            auimlFormatter.setAttribute("required", mandatory);
            auimlFormatter.setAttribute("type", "TIME");
            auimlFormatter.setAttribute("FORMAT-BINDING", formatBinding);
            this.getHmcmlElement().appendChild(auimlFormatter);
        }
    }

    public void addFormatter() {
    }

    static {
        DateFormat df = DateFormat.getTimeInstance(2, Locale.US);
        defaultTimePattern = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toPattern() : "h:mm:ss a";
    }
}

